<!-- <p align="center">
  <a href="https://cakephp.org/" target="_blank" >
    <img alt="BASC" src="webroot/img/cake.logo.svg" width="400" />
  </a>
</p> -->

**BASC** は孫の手（**ba**ck**sc**ratcher）のように「かゆい所に手が届く」便利なWebアプリケーションを開発するプロジェクトです。
フレームワークにCakePHPを採用していることもあり、ロゴは（将来的には）バスクチーズケーキになってい（ると思い）ます。
基本的には社内向けのアプリを開発しますが、部分的に一般公開することもあるかもしれません。

- [開発環境の構築](#開発環境の構築)
  - [データベース](#データベース)
  - [ローカルリポジトリ](#ローカルリポジトリ)
- [本プロジェクトの運用ルール](#本プロジェクトの運用ルール)
  - [開発の流れ](#開発の流れ)
  - [ブランチ構成](#ブランチ構成)
  - [コミットメッセージ](#コミットメッセージ)
  - [作業ブランチのマージリクエスト](#作業ブランチのマージリクエスト)
  - [リリース作業](#リリース作業)
    - [β版リリース](#β版リリース)
    - [本番リリース](#本番リリース)

# 開発環境の構築
## データベース

1. cPanelでbascデータベースを作成する。
2. cPanelでMySQLユーザーを作成する。
3. bascデータベースに作成したMySQLユーザを紐づける。

## ローカルリポジトリ

1. `gitlab.speedia.local` で個人設定から公開鍵を登録する。
    ※鍵は事前に作成しておく。
2. リポジトリをクローンする。
    ```bash
    $ git clone ssh://git@gitlab.speedia.local:22122/SpeediaDeveloperTeam/basc.git
    ```
    実行した場所でbascディレクトリが作成され、その配下にリポジトリから取得した資材が配置される。

    以降の手順におけるパスは `basc` ディレクトリ直下を基準とする。
3. ローカルリポジトリでのGitのユーザ名・メールアドレスを登録する。
    ```bash
    $ git config --local user.name "Your Name"
    $ git config --local user.email you@example.com
    ```
4. ライブラリをインストールする。
    ```bash
    $ composer install
    ```
5. 個人設定ファイル(app_local.php)を初期状態にする。
    ```bash
    $ cp -f config/app_local.example.php config/app_local.php
    ```
6. 個人設定ファイル(app_local.php)をエディタで開き、`Datasources`を適宜設定する。
7. DBを最新の状態に更新する。
    ```bash
    $ bin/cake migrations migrate
    ```

# 本プロジェクトの運用ルール
## 開発の流れ
1. 何らかのプログラム追加・改修を伴うタスクが発生する。
2. GitLabにIssue・Incidentを作成する。
3. mainから作業用ブランチを作成する。
4. 作成したブランチで作業する。
5. 作業が完了したらマージリクエストを作成し、誰かにコードレビューを依頼する。
6. （レビュワー）修正が必要な場合は指摘、問題なければマージリクエストを承認する。
7. β版リリース（※詳細は別項目）を行い、チーム外にレビューを依頼する。
8. 本番リリース（※詳細は別項目）を行う。

## ブランチ構成
```
 feature      main    beta   production
  / hotfix     |        |        |
        x<-----o        |        |
        |     /|        |        |
   x<---|----+ |        |        |
   |    o      |        |        |
   o    |      |        |        |
   |    +----->o        |        |
   o           |        |        |
   |           |        |        |
   +---------->o------->o        |
              /|        |        |
        x----+ |        |        |
        |      |        |        |
        o      |        |        |
        |      |        |        |
        +------o------->o------->o
               |        |        |
               |        |        |
```

| 種別       | 用途         |       フォーマット       |
| :--------- | :----------- | :----------------------: |
| feature    | 機能開発     | <Issue番号>-<任意の名称> |
| hotfix     | 不具合対応   | <Issue番号>-<任意の名称> |
| main       | メイン       |            -             |
| beta       | 早期リリース |            -             |
| production | 正式リリース |            -             |

## コミットメッセージ
フォーマット: `<コミット種別>: <概要>`

コミットメッセージ例）
```
feat: 〇〇機能の追加
^--^  ^-----------^
|           |
|           +-> 変更内容の要約
|      
+-------> コミット種別
```

| コミット種別 | 用途                                   |
| :----------- | :------------------------------------- |
| feat         | ユーザー向けの機能の追加や変更         |
| fix          | ユーザー向けの不具合の修正             |
| docs         | ドキュメントの更新                     |
| style        | フォーマットなどのスタイルに関する修正 |
| refactor     | リファクタリングを目的とした修正       |
| test         | テストコードの追加や修正               |
| chore        | その他                                 |

コミットメッセージの3行目以降は任意だが、変更内容の詳細を記述しておくと親切

## 作業ブランチのマージリクエスト
* 基本はGitLabから行う。
* タイトルは概要を記載する。 ※[コミットメッセージ](#コミットメッセージ)参照
* Reviewer にレビュー依頼する人を設定する。
* 下記のオプションを有効にする。
  - [x] Delete source branch when merge request is accepted.
  - [x] Squash commits when merge request is accepted.

## リリース作業
### β版リリース
未作成

### 本番リリース
未作成